function [] = DecodingResult_pop(SimplyNameT,FullNameT)
%UNTITLED8 此处提供此函数的摘要
%   此处提供详细说明
%% 
divTime=-200:1299;
DataName={'HG','ERP'};

% for i_sub=1:length(SimplyNameT)
% SimplyName=SimplyNameT{i_sub}; 
% FullName=FullNameT{i_sub};
% perfT = DecodingAna(SimplyName,FullName,Cri_Chan);  
% popResult{1,i_sub}=perfT;
% end

%% 汇总结果，函数用
for i_sub=1:length(SimplyNameT)
    nameTemp=FullNameT{i_sub};
    workpath=['E:\DATA_SEEG\',nameTemp,'_data\电生理结果\解码\'];
    load([workpath,'perfT.mat']);
popResult{1,i_sub}=perfT;

end

for i_data=1:2
     DA_T=[];
      DA1_T=[];
    for i_sub=1:length(popResult)

        DA_T(:,i_sub)=popResult{1,i_sub}(i_data).perf;
        DA1_T(:,:,i_sub)=popResult{1,i_sub}(i_data).perf_timextime;
    end
DA_mean=mean(DA_T,2);
DA1_mean=mean(DA1_T,3);

    DA_temp{1,i_data}=DA_mean;
    DA_temp{2,i_data}=DA1_mean;
end
      
%% 检验
time=[-0.2:0.001:1.299];
baseline=mean(DA_T(time<0,:));
pT=[];
for i_time=1:size(DA_T,1)
    pValue=ttest2(0.5,DA_T(i_time,:));
pT(1,i_time)=pValue;
end

pmask=pT<0.05;
 plot(time,pmask)

%% time x time画图
outputpath='E:\DATA_SEEG\汇总结果\';
for i_data=1:2
    figure
        TTtemp=DA_temp{2,i_data};
        c=imagesc(divTime,divTime,TTtemp);
        colormap jet
        cb=colorbar;
        cb.Label.String = 'Decoding Accuracy (%)';
        clim=prctile(TTtemp(divTime>=-200 & divTime>=650,divTime>=...
            -200 & divTime>=650),[5 95],'all')';
        xlim([-200 800])
        ylim([-200 800])
        set(gca,'ydir','normal')
        ylabel('Train time (ms)');
        xlabel('Test time (ms)');
        ax=gca;
        ax.FontSize=15;
        ax.LineWidth=1.5;
        box off
        xline(0,'--','LineWidth',2,'Color','k')
        xline(650,'--','LineWidth',2,'Color','k')
        yline(0,'--','LineWidth',2,'Color','k')
        yline(650,'--','LineWidth',2,'Color','k')
        title(['N=',num2str(size(DA_T,2))]);
        saveas(gcf,[outputpath,'Population_Decoding_Frontal_',DataName{i_data},'_timextime'],'tif');

        %%  画图 Time x Decoding Accuracy

              figure
        TTtemp=DA_temp{1,i_data};

        plot(divTime,smoothdata(TTtemp,1,"movmean",50),'LineWidth',2)
        % ylim([0.45 0.75])
        xlim([-200 800])
        yline(0.5,'LineStyle','--','LineWidth',2)
        xlabel('Time from Cue Onset (ms)');
        ylabel('Decoding Accuracy (%)');
        ax=gca;
        ax.FontSize=15;
        ax.LineWidth=1.5;
        box off
        xline(0,'--','LineWidth',2,'Color','k')
        xline(650,'--','LineWidth',2,'Color','k')
        yline(0.5,'LineWidth',2,'Color',0.8*[1 1 1],'LineStyle','--');
        text(400,0.505,'Chance Level','HorizontalAlignment','center');
        ylim([0.99*min(TTtemp),1.01*max(TTtemp)])
       title(['N=',num2str(size(DA_T,2))]);
        saveas(gcf,[outputpath,'Population_Decoding_Frontal_',DataName{i_data}],'tif');

end

end